definition module DLState;

import StdEnv;
import State;
import ProcessSerialNumber;
import dus_label;

import StdDynamicVersion;

//
import ClientWindow;

import DynamicID;
import StdDynamicLowLevelInterface;
import typetable;
import MemoryState;
import LibraryInstance;
import type_io_equal_types;
import TypeImplementationTable;
import ToAndFromGraph;

:: *DLServerState
	= {
	// general data
		quit_server						:: !Bool
	,	application_path				:: !String
	,	static_application_as_client	:: !Bool
	
	// clients
	,	dl_client_states				:: *[*DLClientState]
	
	// client windows
	,	global_client_window			:: !GlobalClientWindow
	
	// conversions
	,	convert_functions					:: !ConvertFunctions
	
	// NEW TO HANDLE .LIB DEMANDS
	,	dlss_lib_mode					:: !Bool
	,	dlss_lib_command_line			:: !{{#Char}}
	};
		
instance DefaultElemU DLServerState;

AddToDLServerState :: *DLClientState *DLServerState -> *DLServerState; 	
RemoveFromDLServerState :: !ProcessSerialNumber !*DLServerState -> (!Bool,!*DLClientState,!*DLServerState);
	
acc_dl_client_states :: ([*DLClientState] -> (.x,[*DLClientState])) !*DLServerState -> (.x,!*DLServerState);
app_dl_client_states :: ([*DLClientState] -> [*DLClientState]) !*DLServerState -> !*DLServerState;

selacc_client_state :: !ProcessSerialNumber (*DLClientState -> (.x,*DLClientState)) !*DLServerState -> (.x,!*DLServerState);

selacc_app_linker_state :: !ProcessSerialNumber !(*State -> *(.a,*State)) !*DLServerState -> *(.a,*DLServerState);

:: *DLClientState
	= { 
	// client identification
		id						:: !ProcessSerialNumber
	,	initial_link			:: !Bool
		
	// application linker state
	,	app_linker_state		:: !*State
	
	// client window
	,	client_window			:: !ClientWindow
	
	// support for block dynamics (only one
	,	dynamic_ids				:: !*DynamicID
	
	// Library implementation
	,	cs_main_library_name	:: !String
	,	cs_type_tables			:: !*{#TypeTable}
	
	,	cs_dynamic_info			:: !*{#DynamicInfo}
	
	,	cs_library_instances		:: !*LibraryInstances	// all info specific to a library instance
	,	cs_main_library_instance_i	:: !Maybe !Int
	
	,	cs_intra_type_equalities	:: !*EqTypesState
	
	,	cs_type_implementation_table	:: *TypeImplementationTable
	
	,	cs_to_and_from_graph	:: !ToAndFromGraphTable	
	
	,	cs_n_fixed_available_types	:: !Maybe !Int
	
	,	do_dump_dynamic			:: !Bool
	
	,	cs_n_lazy_dynamics		:: !Int						// first free dynamic
	
	,	cs_lazy_dynamic_index_to_dynamic_id	:: !*{#LazyDynamicInfo}		// indexed by lazy_dynamic_index (rt) with No meaning not initialized, Yes is initialized and dynamic id is the integer

	,	cs_share_runtime_system	:: !Bool
	
	,	cs_conversion			:: ![ConversionInfo]

	,	cs_dlink_dir			:: !String

	};
	
:: ConversionInfo
	= {
		ci_version						:: !Version
	,	ci_has_from_graph_been_added	:: !Bool
	,	ci_has_to_graph_been_added		:: !Bool
	};
	
:: LazyDynamicInfo 
	= {
		ldi_lazy_dynamic_index_to_dynamic	:: !Maybe !Int
	,	ldi_parent_index					:: !Int 				// index in cs_dynamic_info
	};
	
instance DefaultElem LazyDynamicInfo;
	
instance DynamicIDs DLClientState;
	
instance DefaultElemU DLClientState;

instance AddMessage DLClientState;

// ClientWindows
timer_id 	:== 0;
free_id		:== timer_id + 1;

app_state ::  (!*State -> !*State) !*DLClientState -> !*DLClientState;
acc_state ::  (!*State -> (!.x,!*State)) !*DLClientState -> !(!.x,*DLClientState);

class AppPdState s
where {
	app_pd_state :: !(*PDState -> !*PDState) !*s -> !*s
};

instance AppPdState DLClientState;
instance AppPdState State;

class AccPdState s
where {
	acc_pd_state :: !(*PDState -> (!.x,!*PDState)) !*s -> (!.x,!*s)
};

instance AccPdState State;
instance AccPdState DLClientState;

InitServerState :: !*DLServerState !*a -> (!*DLServerState,!*a) | FileEnv a;

:: ConvertFunctions = {
		graph_to_string :: [Version]
	,	string_to_graph :: [Version]
	};
	
GetDynamicLinkerDirectory :: !*DLServerState -> (!String,!*DLServerState);

eager_read_version :: !Version !*DLClientState !*DLServerState -> (!Bool,!Version,!*DLClientState,!*DLServerState);		
eager_write_version :: !*DLClientState !*DLServerState -> (!Bool,!Version,!*DLClientState,!*DLServerState);	

get_type_tables :: !*DLClientState -> *(*{#*TypeTable},*DLClientState);
get_ets :: !*DLClientState -> *(!*EqTypesState,*DLClientState);
get_type_implementation_table :: !*DLClientState -> (!*TypeImplementationTable,!*DLClientState);

instance TypeTableOps DLClientState;
instance DynamicInfoOps DLClientState;

instance Library_Instances DLClientState;

print_type_implementation_table :: !*DLClientState -> !*DLClientState;

get_from_graph_function_address2 :: (!Maybe !Version) !*DLClientState -> (ToAndFromGraphEntry,ToAndFromGraphEntryIndex,!*DLClientState);
get_to_graph_function_address2 :: (!Maybe !Version) !*DLClientState -> (Maybe (ToAndFromGraphEntry,ToAndFromGraphEntryIndex),!*DLClientState);

instance symbol_n_to_offset DLClientState;

check_whether_implementation_is_available :: !Int !String !*DLClientState -> (!Bool,!*DLClientState);
check_whether_implementation_is_available2 :: !Int !String !*DLClientState -> (!Bool,!Maybe !(!Int,!Int),!*DLClientState);

findLabel :: !String !Int !*DLClientState -> (!Maybe !(!Int,!Int),!*DLClientState);
isLabelImplemented :: !Int !Int !*DLClientState -> (!Maybe !Int,!*DLClientState);

isTypeImplemented :: !LibraryInstanceTypeReference !*DLClientState -> (!Maybe !(!String,[String]),*DLClientState);
isAnyConstructorOfTypeImplemented :: !LibraryInstanceTypeReference !*DLClientState -> (!Maybe !(!String,[String]),*DLClientState);

get_type_label_names :: !TIO_TypeReference !Int !*DLClientState -> (!String,[String],!*DLClientState);

acc_names_table :: !Int !*DLClientState -> *(.{!NamesTableElement},*DLClientState);	

instance findImplementationType DLClientState;

print_type_table_reference :: !Int !TIO_TypeReference !{#*TypeTable} -> (!String,{#*TypeTable});

get_lazy_dynamic_index_to_dynamic_id :: !*DLClientState -> *(!*{#LazyDynamicInfo},!*DLClientState);

get_number_of_type_tables :: *DLClientState -> *(Int,*DLClientState);

has_strict_field :: !Int !Int !Bool !StrictnessList -> !Bool;

add_object_module_to_library_instance :: {#.Char} !.Int !*DLClientState .a !*f -> *(*DLClientState,.a,!*f) | FileEnv f;


get_state :: !*DLClientState -> (!*State,!*DLClientState);

internal_error :: !{#Char} !ProcessSerialNumber !*DLClientState !*DLServerState .a -> *(!Bool,!ProcessSerialNumber,!DLServerState,.a);		

replaceLabel :: !String !Int !Int !Int !String !*DLClientState -> !*DLClientState;

instance get_type_implementation DLClientState;

instance enter_implementation_type_for_equivalence_class2 DLClientState;

get_dynamic_id :: !Int !*DLClientState -> (!(Maybe (!Int,!Int)),!*DLClientState);

old_enter_type_equation :: !LibraryInstanceTypeReference !LibraryInstanceTypeReference !*DLClientState !*f -> (Maybe (Int,Bool),!*DLClientState,!*f) | FileEnv f;

//enter_type_equation_new3 :: ![.LibraryInstanceTypeReference] *DLClientState *a -> *((Maybe (Int,Bool)),*DLClientState,*a) | FileEnv a;

enter_type_equation_new :: ![.LibraryInstanceTypeReference] *DLClientState *a -> *((Maybe (Int,Bool)),*DLClientState,*a) | FileEnv a;

//instance enter_type_equation DLClientState;

RegisterLibrary :: (Maybe .Int) !{#.Char} !*DLClientState !*f -> *(Int,Int,*DLClientState,!*f) | FileEnv f;

determine_implementation_for_dus_entry :: !String !String !Int !Int !Int !*DLClientState -> *(.DusImplementation,*DLClientState);

instance getImplementationType DLClientState;

instance findTypeUsingTypeName DLClientState;

extractTypeTable_i :: !LibRef !*DLClientState -> (!Int,!*DLClientState);

get_info_library_instance_type_reference :: !LibraryInstanceTypeReference !*DLClientState -> ((!String,!String,Int,Int,TIO_TypeReference),*DLClientState);

convert_lit_type_reference_to_type_table_reference :: !.LibraryInstanceTypeReference !*DLClientState -> *(.TypeTableTypeReference,*DLClientState);

find_type_implementation_equivalent_class :: .LibraryInstanceTypeReference !*DLClientState -> *((Maybe Int),*DLClientState);
